<?php
// Obtener página actual para marcar activa
$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Obtener datos del usuario
$user_name = $_SESSION['user_nombre'] ?? 'Usuario';
$user_email = $_SESSION['user_email'] ?? '';
$empresa_nombre = $_SESSION['empresa_nombre'] ?? 'Mi Empresa';
$user_rol = $_SESSION['user_rol'] ?? 'rrhh';

// Iniciales para el avatar
$initials = '';
$name_parts = explode(' ', $user_name);
foreach ($name_parts as $part) {
    $initials .= strtoupper(substr($part, 0, 1));
}
$initials = substr($initials, 0, 2);
?>

<style>
:root {
    --sidebar-bg: #ffffff;
    --sidebar-border: #e5e7eb;
    --text-primary: #1f2937;
    --text-secondary: #6b7280;
    --text-muted: #9ca3af;
    --accent-color: #3b82f6;
    --hover-bg: #f3f4f6;
    --active-bg: #dbeafe;
    --active-text: #1d4ed8;
    --green-primary: #22c55e;
    --green-light: #dcfce7;
}

.sidebar {
    width: 280px;
    height: 100vh;
    background: var(--sidebar-bg);
    border-right: 1px solid var(--sidebar-border);
    position: fixed;
    left: 0;
    top: 0;
    overflow-y: auto;
    z-index: 1000;
    transition: transform 0.3s ease;
}

.sidebar-header {
    padding: 1.5rem 1.5rem 1rem;
    border-bottom: 1px solid var(--sidebar-border);
}

.sidebar-logo {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: var(--text-primary);
}

.sidebar-logo h1 {
    font-size: 1.75rem;
    font-weight: 800;
    margin: 0;
    letter-spacing: -0.02em;
}

.brand-name {
    color: var(--green-primary);
}

.sidebar-content {
    padding: 1rem 0;
}

.menu-section {
    margin-bottom: 2rem;
}

.menu-section-title {
    font-size: 0.75rem;
    font-weight: 600;
    color: var(--text-muted);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    padding: 0 1.5rem;
    margin-bottom: 0.5rem;
}

.menu-items {
    list-style: none;
    margin: 0;
    padding: 0;
}

.menu-item {
    margin-bottom: 0.25rem;
}

.menu-link {
    display: flex;
    align-items: center;
    padding: 0.75rem 1.5rem;
    color: var(--text-secondary);
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s ease;
    position: relative;
}

.menu-link:hover {
    background-color: var(--hover-bg);
    color: var(--text-primary);
}

.menu-link.active {
    background-color: var(--active-bg);
    color: var(--active-text);
    font-weight: 600;
}

.menu-link.active::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 3px;
    background: var(--accent-color);
}

.menu-icon {
    width: 20px;
    height: 20px;
    margin-right: 0.75rem;
    flex-shrink: 0;
}

.menu-badge {
    margin-left: auto;
    background: var(--green-primary);
    color: white;
    font-size: 0.75rem;
    font-weight: 600;
    padding: 0.25rem 0.5rem;
    border-radius: 12px;
    min-width: 20px;
    text-align: center;
}

.menu-badge.yellow {
    background: #f59e0b;
}

.menu-badge.blue {
    background: #3b82f6;
}

.menu-badge.red {
    background: #ef4444;
}

.sidebar-footer {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    padding: 1.5rem;
    border-top: 1px solid var(--sidebar-border);
    background: var(--sidebar-bg);
}

.user-info {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: var(--text-primary);
    transition: all 0.2s ease;
}

.user-info:hover {
    color: var(--accent-color);
}

.user-avatar {
    width: 40px;
    height: 40px;
    background: var(--green-primary);
    color: white;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 0.875rem;
    margin-right: 0.75rem;
    flex-shrink: 0;
}

.user-details h6 {
    margin: 0;
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--text-primary);
}

.user-details p {
    margin: 0;
    font-size: 0.75rem;
    color: var(--text-secondary);
}

.company-info {
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--sidebar-border);
}

.company-info p {
    margin: 0;
    font-size: 0.75rem;
    color: var(--text-muted);
    text-align: center;
}

/* Responsive */
@media (max-width: 768px) {
    .sidebar {
        transform: translateX(-100%);
    }
    
    .sidebar.show {
        transform: translateX(0);
    }
}

/* Animaciones */
.menu-link {
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.menu-link:hover .menu-icon {
    transform: scale(1.1);
}

.sidebar::-webkit-scrollbar {
    width: 6px;
}

.sidebar::-webkit-scrollbar-track {
    background: var(--sidebar-bg);
}

.sidebar::-webkit-scrollbar-thumb {
    background: var(--sidebar-border);
    border-radius: 3px;
}

.sidebar::-webkit-scrollbar-thumb:hover {
    background: var(--text-muted);
}
</style>

<div class="sidebar">
    <!-- Header con Logo -->
    <div class="sidebar-header">
        <a href="dashboard.php" class="sidebar-logo">
            <h1><span class="brand-name">Asistool</span></h1>
        </a>
    </div>

    <!-- Contenido del Menú -->
    <div class="sidebar-content">
        <!-- Sección Principal -->
        <div class="menu-section">
            <div class="menu-section-title">Principal</div>
            <ul class="menu-items">
                <li class="menu-item">
                    <a href="dashboard.php" class="menu-link <?= $current_page == 'dashboard' ? 'active' : '' ?>">
                        <i class="fas fa-chart-pie menu-icon"></i>
                        Dashboard
                    </a>
                </li>
            </ul>
        </div>

        <!-- Sección Gestión de Personal -->
        <div class="menu-section">
            <div class="menu-section-title">Gestión de Personal</div>
            <ul class="menu-items">
                <li class="menu-item">
                    <a href="empleados.php" class="menu-link <?= $current_page == 'empleados' ? 'active' : '' ?>">
                        <i class="fas fa-users menu-icon"></i>
                        Empleados
                        <span class="menu-badge blue">
                            <?php
                            // Contar empleados activos
                            $total_empleados = $db->count(
                                "SELECT COUNT(*) FROM empleados WHERE empresa_id = ? AND activo = 1", 
                                [getEmpresaActual()]
                            );
                            echo $total_empleados;
                            ?>
                        </span>
                    </a>
                </li>
                
                <li class="menu-item">
                    <a href="asistencia.php" class="menu-link <?= $current_page == 'asistencia' ? 'active' : '' ?>">
                        <i class="fas fa-clipboard-check menu-icon"></i>
                        Pase de Lista
                        <?php
                        // Verificar si ya se pasó lista hoy
                        $lista_hoy = $db->count(
                            "SELECT COUNT(*) FROM asistencias WHERE empresa_id = ? AND fecha = CURDATE()", 
                            [getEmpresaActual()]
                        );
                        if ($lista_hoy == 0):
                        ?>
                        <span class="menu-badge red">¡Hoy!</span>
                        <?php endif; ?>
                    </a>
                </li>
                
                <li class="menu-item">
                    <a href="reportes.php" class="menu-link <?= $current_page == 'reportes' ? 'active' : '' ?>">
                        <i class="fas fa-chart-bar menu-icon"></i>
                        Reportes
                    </a>
                </li>
                
                <li class="menu-item">
                    <a href="proyectos.php" class="menu-link <?= $current_page == 'proyectos' ? 'active' : '' ?>">
                        <i class="fas fa-project-diagram menu-icon"></i>
                        Proyectos
                        <span class="menu-badge yellow">
                            <?php
                            // Contar proyectos activos
                            $total_proyectos = $db->count(
                                "SELECT COUNT(*) FROM proyectos WHERE empresa_id = ? AND activo = 1", 
                                [getEmpresaActual()]
                            );
                            echo $total_proyectos;
                            ?>
                        </span>
                    </a>
                </li>
            </ul>
        </div>

        <!-- Sección Sistema -->
        <div class="menu-section">
            <div class="menu-section-title">Sistema</div>
            <ul class="menu-items">
                <li class="menu-item">
                    <a href="configuracion.php" class="menu-link <?= $current_page == 'configuracion' ? 'active' : '' ?>">
                        <i class="fas fa-cog menu-icon"></i>
                        Configuración
                    </a>
                </li>
                
                <li class="menu-item">
                    <a href="perfil.php" class="menu-link <?= $current_page == 'perfil' ? 'active' : '' ?>">
                        <i class="fas fa-user-circle menu-icon"></i>
                        Mi Perfil
                    </a>
                </li>
                
                <li class="menu-item">
                    <a href="../logout.php" class="menu-link" onclick="return confirm('¿Estás seguro que deseas cerrar sesión?')">
                        <i class="fas fa-sign-out-alt menu-icon"></i>
                        Cerrar Sesión
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <!-- Footer con Info del Usuario -->
    <div class="sidebar-footer">
        <div class="user-info">
            <div class="user-avatar">
                <?= $initials ?>
            </div>
            <div class="user-details">
                <h6><?= htmlspecialchars($user_name) ?></h6>
                <p><?= htmlspecialchars($user_email) ?></p>
            </div>
        </div>
        
        <div class="company-info">
            <p>© 2024, Asistool</p>
            <p>Versión 1.0</p>
        </div>
    </div>
</div>

<!-- Script para menú responsive -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle sidebar en móvil
    const toggleBtn = document.querySelector('.sidebar-toggle');
    const sidebar = document.querySelector('.sidebar');
    
    if (toggleBtn) {
        toggleBtn.addEventListener('click', function() {
            sidebar.classList.toggle('show');
        });
    }
    
    // Cerrar sidebar al hacer click fuera en móvil
    document.addEventListener('click', function(e) {
        if (window.innerWidth <= 768) {
            if (!sidebar.contains(e.target) && !e.target.closest('.sidebar-toggle')) {
                sidebar.classList.remove('show');
            }
        }
    });
    
    // Animación suave para los links del menú
    const menuLinks = document.querySelectorAll('.menu-link');
    menuLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            if (this.getAttribute('href').startsWith('#')) {
                e.preventDefault();
                return;
            }
            
            // Añadir efecto de loading
            this.style.opacity = '0.7';
            setTimeout(() => {
                this.style.opacity = '1';
            }, 200);
        });
    });
});
</script>