<?php
session_start();

// Verificar si existe el archivo config.php antes de incluirlo
if (file_exists('includes/config.php')) {
    require_once 'includes/config.php';
} else {
    // Mostrar error amigable si no existe config.php
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Asistool - Configuración Pendiente</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <style>
            body {
                background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 50%, #86efac 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                font-family: 'Inter', sans-serif;
            }
            .setup-container {
                background: white;
                padding: 3rem;
                border-radius: 16px;
                box-shadow: 0 20px 40px rgba(0,0,0,0.1);
                max-width: 600px;
                text-align: center;
            }
            .logo {
                color: #22c55e;
                font-size: 3rem;
                font-weight: 800;
                margin-bottom: 1rem;
            }
            .step {
                background: #f8fafc;
                padding: 1.5rem;
                margin: 1rem 0;
                border-radius: 12px;
                border-left: 4px solid #22c55e;
                text-align: left;
            }
            .step-number {
                background: #22c55e;
                color: white;
                width: 30px;
                height: 30px;
                border-radius: 50%;
                display: inline-flex;
                align-items: center;
                justify-content: center;
                font-weight: bold;
                margin-right: 1rem;
            }
            .code-block {
                background: #1f2937;
                color: #10b981;
                padding: 1rem;
                border-radius: 8px;
                font-family: 'Courier New', monospace;
                margin: 1rem 0;
                font-size: 0.9rem;
            }
        </style>
    </head>
    <body>
        <div class="setup-container">
            <div class="logo">Asistool</div>
            <h2>⚙️ Configuración Pendiente</h2>
            <p class="text-muted mb-4">Necesitas completar la instalación para continuar</p>
            
            <div class="step">
                <span class="step-number">1</span>
                <strong>Crear carpeta includes/</strong>
                <div class="code-block">
                    mkdir includes
                </div>
            </div>
            
            <div class="step">
                <span class="step-number">2</span>
                <strong>Subir archivo config.php a includes/</strong>
                <p class="text-muted small mt-2">El archivo config.php debe estar en: <code>includes/config.php</code></p>
            </div>
            
            <div class="step">
                <span class="step-number">3</span>
                <strong>Crear base de datos</strong>
                <p class="text-muted small mt-2">
                    Nombre: <code>symcarpe_asistencia</code><br>
                    Usuario: <code>symcarpe_admin</code><br>
                    Contraseña: <code>Losmolles06</code>
                </p>
            </div>
            
            <div class="step">
                <span class="step-number">4</span>
                <strong>Crear carpeta admin/</strong>
                <div class="code-block">
                    mkdir admin
                </div>
            </div>
            
            <div class="alert alert-info mt-4">
                <i class="fas fa-info-circle"></i>
                <strong>Estado actual:</strong> Archivo config.php no encontrado en <code>includes/config.php</code>
            </div>
            
            <p class="text-muted mt-4">
                Una vez que subas todos los archivos, actualiza esta página para continuar.
            </p>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Si ya está logueado, redirigir al dashboard
if (isLoggedIn()) {
    header("Location: admin/dashboard.php");
    exit;
}

$error = '';
$success = '';

if ($_POST) {
    $email = sanitize($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        $error = 'Por favor completa todos los campos';
    } else {
        try {
            // Buscar usuario en la base de datos
            $sql = "SELECT u.*, e.nombre as empresa_nombre, e.plan, e.activo as empresa_activa 
                    FROM usuarios u 
                    INNER JOIN empresas e ON u.empresa_id = e.id 
                    WHERE u.email = ? AND u.activo = 1";
            
            $user = $db->fetch($sql, [$email]);
            
            if ($user && verifyPassword($password, $user['password'])) {
                if (!$user['empresa_activa']) {
                    $error = 'Tu empresa no está activa. Contacta al administrador.';
                } else {
                    // Login exitoso
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['user_nombre'] = $user['nombre'];
                    $_SESSION['user_email'] = $user['email'];
                    $_SESSION['user_rol'] = $user['rol'];
                    $_SESSION['user_empresa_id'] = $user['empresa_id'];
                    $_SESSION['empresa_nombre'] = $user['empresa_nombre'];
                    $_SESSION['empresa_plan'] = $user['plan'];
                    
                    // Actualizar último acceso
                    $db->query("UPDATE usuarios SET ultimo_acceso = NOW() WHERE id = ?", [$user['id']]);
                    
                    header("Location: admin/dashboard.php");
                    exit;
                }
            } else {
                $error = 'Credenciales incorrectas';
            }
        } catch (Exception $e) {
            $error = 'Error del sistema. Inténtalo más tarde.';
            if (function_exists('logError')) {
                logError('Error en login: ' . $e->getMessage());
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asistool - Control de Asistencia</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4ade80;
            --secondary-color: #22c55e;
            --accent-color: #16a34a;
            --bg-gradient: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 50%, #86efac 100%);
            --text-dark: #1f2937;
            --text-light: #6b7280;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: #f8fafc;
            min-height: 100vh;
        }

        .login-container {
            min-height: 100vh;
            display: flex;
        }

        .login-left {
            flex: 1;
            background: var(--bg-gradient);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 2rem;
            position: relative;
            overflow: hidden;
        }

        .login-left::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="10" cy="10" r="1" fill="%23ffffff20"/><circle cx="90" cy="20" r="1.5" fill="%23ffffff30"/><circle cx="20" cy="80" r="1" fill="%23ffffff20"/><circle cx="80" cy="90" r="1.2" fill="%23ffffff25"/></svg>');
            animation: float 20s infinite linear;
        }

        @keyframes float {
            0% { transform: translateY(0px) translateX(0px); }
            33% { transform: translateY(-30px) translateX(10px); }
            66% { transform: translateY(-20px) translateX(-10px); }
            100% { transform: translateY(0px) translateX(0px); }
        }

        .illustration {
            max-width: 500px;
            z-index: 2;
            position: relative;
        }

        .login-illustration {
            width: 100%;
            height: auto;
            filter: drop-shadow(0 20px 40px rgba(34, 197, 94, 0.2));
        }

        .login-right {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 2rem;
            background: white;
        }

        .login-form-container {
            width: 100%;
            max-width: 400px;
        }

        .logo {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo h1 {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--text-dark);
            margin-bottom: 0.25rem;
            letter-spacing: -0.02em;
        }

        .logo .brand-name {
            color: var(--primary-color);
        }

        .logo p {
            color: var(--text-light);
            font-size: 0.9rem;
            margin: 0;
        }

        .role-badge {
            display: inline-block;
            background: var(--primary-color);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 600;
            margin-bottom: 2rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            font-weight: 600;
            color: var(--text-dark);
            margin-bottom: 0.5rem;
            display: block;
        }

        .form-control {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 0.875rem 1rem;
            font-size: 1rem;
            background: #f9fafb;
            transition: all 0.3s ease;
            width: 100%;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            background: white;
            box-shadow: 0 0 0 3px rgba(74, 222, 128, 0.1);
            outline: none;
        }

        .password-toggle {
            position: relative;
        }

        .password-toggle .toggle-btn {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--text-light);
            cursor: pointer;
            padding: 0.25rem;
        }

        .forgot-password {
            text-align: right;
            margin-bottom: 2rem;
        }

        .forgot-password a {
            color: var(--primary-color);
            text-decoration: none;
            font-size: 0.875rem;
            font-weight: 500;
        }

        .forgot-password a:hover {
            text-decoration: underline;
        }

        .btn-login {
            background: var(--primary-color);
            border: none;
            color: white;
            padding: 1rem;
            border-radius: 12px;
            font-size: 1rem;
            font-weight: 600;
            width: 100%;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .btn-login:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(74, 222, 128, 0.3);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 2rem;
            border-top: 1px solid #e5e7eb;
            color: var(--text-light);
            font-size: 0.875rem;
        }

        .footer a {
            color: var(--primary-color);
            text-decoration: none;
        }

        .alert {
            border-radius: 12px;
            border: none;
            margin-bottom: 1.5rem;
        }

        .alert-danger {
            background: #fef2f2;
            color: #dc2626;
        }

        .alert-success {
            background: #f0fdf4;
            color: #16a34a;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
            }
            
            .login-left {
                min-height: 40vh;
            }
            
            .illustration {
                max-width: 300px;
            }
            
            .logo h1 {
                font-size: 2rem;
            }
        }

        /* Animaciones */
        .login-right {
            animation: slideInRight 0.6s ease-out;
        }

        .login-left {
            animation: slideInLeft 0.6s ease-out;
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(50px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-50px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <!-- Lado Izquierdo - Ilustración -->
        <div class="login-left">
            <div class="illustration">
                <svg class="login-illustration" viewBox="0 0 600 400" xmlns="http://www.w3.org/2000/svg">
                    <!-- Fondo de montañas -->
                    <polygon points="0,300 150,180 300,220 450,140 600,200 600,400 0,400" fill="#22c55e" opacity="0.8"/>
                    <polygon points="0,320 120,220 280,260 420,180 600,240 600,400 0,400" fill="#16a34a" opacity="0.6"/>
                    
                    <!-- Edificio/Oficina -->
                    <rect x="200" y="180" width="200" height="120" fill="#374151" rx="8"/>
                    <rect x="210" y="190" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    <rect x="250" y="190" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    <rect x="290" y="190" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    <rect x="330" y="190" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    <rect x="210" y="240" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    <rect x="250" y="240" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    <rect x="290" y="240" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    <rect x="330" y="240" width="30" height="40" fill="#60a5fa" opacity="0.8"/>
                    
                    <!-- Bandera con check -->
                    <rect x="350" y="130" width="3" height="50" fill="#374151"/>
                    <polygon points="353,130 353,150 385,140" fill="#4ade80"/>
                    <circle cx="370" cy="138" r="8" fill="white"/>
                    <path d="M366,138 L369,141 L374,136" stroke="#22c55e" stroke-width="2" fill="none" stroke-linecap="round"/>
                    
                    <!-- Personas trabajando -->
                    <circle cx="120" cy="280" r="15" fill="#fbbf24"/>
                    <rect x="110" y="295" width="20" height="35" fill="#3b82f6" rx="10"/>
                    <rect x="105" y="305" width="10" height="25" fill="#fbbf24"/>
                    <rect x="125" y="305" width="10" height="25" fill="#fbbf24"/>
                    
                    <circle cx="480" cy="290" r="15" fill="#fbbf24"/>
                    <rect x="470" y="305" width="20" height="35" fill="#ef4444" rx="10"/>
                    <rect x="465" y="315" width="10" height="25" fill="#fbbf24"/>
                    <rect x="485" y="315" width="10" height="25" fill="#fbbf24"/>
                    
                    <!-- Elementos decorativos -->
                    <circle cx="100" cy="100" r="20" fill="white" opacity="0.3"/>
                    <circle cx="500" cy="80" r="15" fill="white" opacity="0.4"/>
                    <circle cx="450" cy="110" r="10" fill="white" opacity="0.3"/>
                </svg>
            </div>
            
            <div class="text-center mt-4">
                <h2 style="color: #1f2937; font-weight: 700; font-size: 1.8rem; margin-bottom: 0.5rem;">
                    Control de Asistencia Inteligente
                </h2>
                <p style="color: #4b5563; font-size: 1rem;">
                    Plataforma integral para la administración<br>
                    y control de asistencia laboral
                </p>
            </div>
        </div>

        <!-- Lado Derecho - Formulario -->
        <div class="login-right">
            <div class="login-form-container">
                <!-- Logo -->
                <div class="logo">
                    <h1><span class="brand-name">Asistool</span></h1>
                    <span class="role-badge">
                        <i class="fas fa-user-tie"></i> Administrador
                    </span>
                </div>

                <!-- Alertas -->
                <?php if ($error): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle"></i> <?= $error ?>
                    </div>
                <?php endif; ?>

                <?php if ($success): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> <?= $success ?>
                    </div>
                <?php endif; ?>

                <!-- Formulario -->
                <form method="POST" action="">
                    <div class="form-group">
                        <label class="form-label">Ingresa tu Usuario</label>
                        <input type="email" name="email" class="form-control" 
                               placeholder="usuario@empresa.com" 
                               value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Ingresa tu clave</label>
                        <div class="password-toggle">
                            <input type="password" name="password" id="password" 
                                   class="form-control" placeholder="••••••••" required>
                            <button type="button" class="toggle-btn" onclick="togglePassword()">
                                <i class="fas fa-eye" id="eyeIcon"></i>
                            </button>
                        </div>
                    </div>

                    <div class="forgot-password">
                        <a href="#" onclick="alert('Contacta al administrador del sistema')">
                            Olvidé mi clave
                        </a>
                    </div>

                    <button type="submit" class="btn-login">
                        <i class="fas fa-sign-in-alt"></i> Ingresar
                    </button>
                </form>

                <!-- Footer -->
                <div class="footer">
                    Todos los derechos reservados. <a href="#">Términos de Uso</a> de canales digitales de<br>
                    Asistool.<br>
                    © 2024, Asistool<br>
                    Versión 1.0
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function togglePassword() {
            const passwordField = document.getElementById('password');
            const eyeIcon = document.getElementById('eyeIcon');
            
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                eyeIcon.classList.remove('fa-eye');
                eyeIcon.classList.add('fa-eye-slash');
            } else {
                passwordField.type = 'password';
                eyeIcon.classList.remove('fa-eye-slash');
                eyeIcon.classList.add('fa-eye');
            }
        }

        // Auto-focus en el primer campo
        document.addEventListener('DOMContentLoaded', function() {
            const emailField = document.querySelector('input[name="email"]');
            if (emailField) {
                emailField.focus();
            }
        });

        // Animación del botón de login
        const loginBtn = document.querySelector('.btn-login');
        if (loginBtn) {
            loginBtn.addEventListener('click', function(e) {
                this.style.transform = 'scale(0.98)';
                setTimeout(() => {
                    this.style.transform = '';
                }, 150);
            });
        }
    </script>
</body>
</html>