<?php
session_start();
require_once 'includes/config.php';

// Verificar si hay sesión activa
if (isLoggedIn()) {
    // Registrar logout en logs si es necesario
    logError('Usuario cerró sesión: ' . ($_SESSION['user_email'] ?? 'desconocido'));
    
    // Limpiar todas las variables de sesión
    $_SESSION = array();
    
    // Destruir la cookie de sesión si existe
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    
    // Destruir la sesión
    session_destroy();
}

// Redirigir al login
redirect('login.php');
?>